
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from Subscription.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class Subscription( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::External::Subscription"

   @staticmethod
   def protRowType( ):
     return Subscription.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( Subscription.rowType_ == 0 ) or
         ( Subscription.rowType_ == rowTypeId )):
       Subscription.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, Subscription.rowType_,
                                 Subscription.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(Subscription, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(Subscription, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "Subscription" )
      else:
         super(Subscription, self).__init__( length =  62 )

   def oid(self):
      return self.extU32( 4 )
   def system_description(self):
      return self.extU32( 8 )
   def queryText(self):
      return self.strFrom( 12 )
   def outputPath(self):
      return self.strFrom( 16 )
   def typeName(self):
      return self.strFrom( 20 )
   def type_signature(self):
      return self.strFrom( 24 )
   def desiredFlags(self):
      return self.extU16( 28 )
   def flags(self):
      return self.extU16( 30 )
   def standing(self):
      return self.extBool( 32 )
   def scrub(self):
      return self.extBool( 33 )
   def paramName(self):
      return self.varAryFrom( 34, ArrowTypes.ar_string )
   def paramValue(self):
      return self.varAryFrom( 38, ArrowTypes.ar_string )
   def ptime(self):
      return self.extU64( 42 )
   def features(self):
      return self.extU32( 50 )
   def tableParamNames(self):
      return self.varAryFrom( 54, ArrowTypes.ar_string )
   def tableParamValues(self):
      return self.varAryFrom( 58, ArrowTypes.ar_string )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def system_descriptionIs( self, v ):
      return self.insertU32( 8, v )
   def queryTextIs( self, v ):
      return self.insertString( 12, v )
   def outputPathIs( self, v ):
      return self.insertString( 16, v )
   def typeNameIs( self, v ):
      return self.insertString( 20, v )
   def type_signatureIs( self, v ):
      return self.insertString( 24, v )
   def desiredFlagsIs( self, v ):
      return self.insertU16( 28, v )
   def flagsIs( self, v ):
      return self.insertU16( 30, v )
   def standingIs( self, v ):
      return self.insertBool( 32, v )
   def scrubIs( self, v ):
      return self.insertBool( 33, v )
   def paramNameIs( self, v ):
      return self.insertVarAry( 34, v, ArrowTypes.ar_string )
   def paramValueIs( self, v ):
      return self.insertVarAry( 38, v, ArrowTypes.ar_string )
   def ptimeIs( self, v ):
      return self.insertU64( 42, v )
   def featuresIs( self, v ):
      return self.insertU32( 50, v )
   def tableParamNamesIs( self, v ):
      return self.insertVarAry( 54, v, ArrowTypes.ar_string )
   def tableParamValuesIs( self, v ):
      return self.insertVarAry( 58, v, ArrowTypes.ar_string )



   def __eq__( self, o ):
      return self.system_description() == o.system_description() and \
             self.outputPath() == o.outputPath()

   def __hash__( self ):
      l = ( self.system_description(), self.outputPath() )
      return hash( l )

   def __lt__( self, o ):
      if self.system_description() < o.system_description():
         return True
      if self.system_description() > o.system_description():
         return False
      if self.outputPath() < o.outputPath():
         return True
      if self.outputPath() > o.outputPath():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.system_description() == o.system_description() and \
             self.queryText() == o.queryText() and \
             self.outputPath() == o.outputPath() and \
             self.typeName() == o.typeName() and \
             self.type_signature() == o.type_signature() and \
             self.desiredFlags() == o.desiredFlags() and \
             self.flags() == o.flags() and \
             self.standing() == o.standing() and \
             self.scrub() == o.scrub() and \
             self.paramName() == o.paramName() and \
             self.paramValue() == o.paramValue() and \
             self.ptime() == o.ptime() and \
             self.features() == o.features() and \
             self.tableParamNames() == o.tableParamNames() and \
             self.tableParamValues() == o.tableParamValues()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'system_description = %u' % (self.system_description()) + ", "
      v = v + 'queryText = \"%s\"' % (self.queryText()) + ", "
      v = v + 'outputPath = \"%s\"' % (self.outputPath()) + ", "
      v = v + 'typeName = \"%s\"' % (self.typeName()) + ", "
      v = v + 'type_signature = \"%s\"' % (self.type_signature()) + ", "
      v = v + 'desiredFlags = %u' % (self.desiredFlags()) + ", "
      v = v + 'flags = %u' % (self.flags()) + ", "
      v = v + 'standing = %s' % (self.formatBool(self.standing())) + ", "
      v = v + 'scrub = %s' % (self.formatBool(self.scrub())) + ", "
      v = v + 'paramName = [ %s ]' % (self.arrayToString(self.paramName(), '\"%s\"')) + ", "
      v = v + 'paramValue = [ %s ]' % (self.arrayToString(self.paramValue(), '\"%s\"')) + ", "
      v = v + 'ptime = %u' % (self.ptime()) + ", "
      v = v + 'features = %u' % (self.features()) + ", "
      v = v + 'tableParamNames = [ %s ]' % (self.arrayToString(self.tableParamNames(), '\"%s\"')) + ", "
      v = v + 'tableParamValues = [ %s ]' % (self.arrayToString(self.tableParamValues(), '\"%s\"'))
      return v
