
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from Publication.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class Publication( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::External::Publication"

   @staticmethod
   def protRowType( ):
     return Publication.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( Publication.rowType_ == 0 ) or
         ( Publication.rowType_ == rowTypeId )):
       Publication.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, Publication.rowType_,
                                 Publication.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(Publication, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(Publication, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "Publication" )
      else:
         super(Publication, self).__init__( length =  45 )

   def oid(self):
      return self.extU32( 4 )
   def subscription_id(self):
      return self.extU32( 8 )
   def publication_id(self):
      return self.extU32( 12 )
   def view_id(self):
      return self.extU32( 16 )
   def connection_id(self):
      return self.extU32( 20 )
   def tableId(self):
      return self.extU32( 24 )
   def typeId(self):
      return self.extU32( 28 )
   def ptime(self):
      return self.extU64( 32 )
   def status(self):
      return self.extBool( 40 )
   def error(self):
      return self.strFrom( 41 )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def subscription_idIs( self, v ):
      return self.insertU32( 8, v )
   def publication_idIs( self, v ):
      return self.insertU32( 12, v )
   def view_idIs( self, v ):
      return self.insertU32( 16, v )
   def connection_idIs( self, v ):
      return self.insertU32( 20, v )
   def tableIdIs( self, v ):
      return self.insertU32( 24, v )
   def typeIdIs( self, v ):
      return self.insertU32( 28, v )
   def ptimeIs( self, v ):
      return self.insertU64( 32, v )
   def statusIs( self, v ):
      return self.insertBool( 40, v )
   def errorIs( self, v ):
      return self.insertString( 41, v )



   def __eq__( self, o ):
      return self.subscription_id() == o.subscription_id()

   def __hash__( self ):
      l = ( self.subscription_id() )
      return hash( l )

   def __lt__( self, o ):
      if self.subscription_id() < o.subscription_id():
         return True
      if self.subscription_id() > o.subscription_id():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.subscription_id() == o.subscription_id() and \
             self.publication_id() == o.publication_id() and \
             self.view_id() == o.view_id() and \
             self.connection_id() == o.connection_id() and \
             self.tableId() == o.tableId() and \
             self.typeId() == o.typeId() and \
             self.ptime() == o.ptime() and \
             self.status() == o.status() and \
             self.error() == o.error()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'subscription_id = %u' % (self.subscription_id()) + ", "
      v = v + 'publication_id = %u' % (self.publication_id()) + ", "
      v = v + 'view_id = %u' % (self.view_id()) + ", "
      v = v + 'connection_id = %u' % (self.connection_id()) + ", "
      v = v + 'tableId = %u' % (self.tableId()) + ", "
      v = v + 'typeId = %u' % (self.typeId()) + ", "
      v = v + 'ptime = %u' % (self.ptime()) + ", "
      v = v + 'status = %s' % (self.formatBool(self.status())) + ", "
      v = v + 'error = \"%s\"' % (self.error())
      return v
