# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Arrow protocol version
ArrowATPVersion = 3

# current ArrowDb Version
ArrowDbVersion = "1"

# unix domain socket name -- the prefix 0x00 informs
# linux that this is an abstract domain socket
UnixServerAddress = "\x00ArrowATPSock"
DefaultArrowServerPort = 9996
AtpUnixDomainEnvVar = "ATP_SOCKNAME"
AtpTcpPortEnvVar = "ATP_PORTNUMBER"

# ArrowTransportProtocol message types
class ArrowMessageType( object ):
   def __init__( self ):
      self.rowIs = 1
      self.rowDel = 2
      self.rowDelRange = 3

# frontend/backend communication types
mnt_invokeQuery = 1
mnt_cancelQuery = 2

# protocol parameters

# see /src/Arrow/protocol/TransportProtocol.h for a detailed description of
# the ATP message format.

# length of the row length field in a BaseRow (16 bits)
rowLengthLength = 2

# length of the ATP protocol version (16 bits)
protocolLength = 2

# length of message preamble (packed C struct so we cannot calculate directly)
preambleLength = 6

# preamble offsets
msgTypeOffset = 0
tableIdOffset = 2
pathLengthOffset = 4

# query parameter definitions
qpOutputSuffix = "_output_"

# received message interval between server ptime notifications
# in the subscription.  Used for all row communications:
# rowIs, rowDel, rowDelRange
PtimeNotificationInterval = 50

# predefined table paths.  Those paths with %s are modified
# so that agent name is part of its path.

acTablePath  = "arrow/metadata/arClass"
atTablePath  = "arrow/metadata/arTable"
sdTablePath  = "arrow/metadata/SystemDescription"
sbTablePath  = "arrow/External/Subscription"
sbwTablePath = "arrow/External/input/%s/Subscription"
puTablePath  = "arrow/External/Publication"
genFilesTablePath = "arrow/arCtrl/gen_files"

# predefined class identifications

acClassId = 1
atClassId = 2
sdClassId = 6

# predefined table identifications

acTableId = 1           # arClass id
atTableId = 2           # arTable id
sdTableId = 6           # SystemDescription id

# SystemDescription
#   properties

sdRejectionPattern = 0x0

systemPropertiesExternalClient = 0x1
systemPropertiesTransientDefault = 0x2

clientPropertiesTransient = 0x2
clientPropertiesDirect = 0x4

subscriptionFeatureNoHandshake = 1
subscriptionFeatureDirect = 2
subscriptionFeatureSchedule = 4
SubscriptionFeatureFlowCtrl = 8
SubscriptionFeatureInorder = 16
SubscriptionFeatureNoCoalescing = 32


# QMsgBase types

qmbQuery = 1
qmbReader = 2
qmbWriter = 3

#   Server agentName
sdServerName = "ar"
#   Server connection_id
sdServerConnectionId = "ArrowDb"

