#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import errno
import os
import random
import socket
import sys
from ClientLibConstants import DefaultArrowServerPort
from ClientLibConstants import UnixServerAddress

AtpUnixDomainEnvVar = "ATP_SOCKNAME"
AtpTcpPortEnvVar = "ATP_PORTNUMBER"

def getArrowServerPort( dbname="ar" ):
   _ignore = dbname
   return os.getenv( AtpTcpPortEnvVar, DefaultArrowServerPort )
def setArrowServerPort( portNum, dbname="ar" ):
   _ignore = dbname
   os.environ[ AtpTcpPortEnvVar ] = str( int( portNum ) )

def getArrowDomainSocket( dbname="ar" ):
   """Return the UNIX Domain Socket to be used by Arrow, based on the
   default and environment variable.  Because it is hard to add
   a leading 0 to environment variable strings, this function returns
   the domain socket name *without* the leading 0."""
   # We could adopt the convention that "@" in the environment variable
   # is replaced with \000 --- worth it?
   defaultName = ( UnixServerAddress[ 1: ] + dbname )

   name = os.getenv( AtpUnixDomainEnvVar, defaultName )
   if( name[0] != "\x00" ):
      name = "\x00" + name
   return name

def setArrowDomainSocket( sockName ):
   sockName = str( sockName )
   if( sockName[0] == "\x00" ):
      sockName = sockName[1:]
   os.environ[ AtpUnixDomainEnvVar ] = sockName

def findUnusedArrowPort():
   s = socket.socket( socket.AF_INET, socket.SOCK_STREAM )
   s.setsockopt( socket.SOL_SOCKET, socket.SO_REUSEADDR, 1 )
   INADDR_ANY = '' # python's convention
   s.bind( ( INADDR_ANY, 0 ) )
   _host, port = s.getsockname()
   # Hopefully, SO_LINGER will keep this busy so other people who try
   # to get a random binding to a port won't get this one, until our
   # ArrowServer grabs it.
   s.close()
   return port

def findUnusedArrowUnixSockname():
   sockname = UnixServerAddress # includes leading \000 byte
   s = socket.socket( socket.AF_UNIX, socket.SOCK_STREAM )
   s.setsockopt( socket.SOL_SOCKET, socket.SO_REUSEADDR, 1 )
   arrowName = None
   for _i in range( 50 ):
      try:
         candidate = sockname + str( random.randint( 0, 10000 ) )
         s.bind( candidate )
         arrowName = candidate
         s.close()
         # success
         break
      except socket.error, ( errNo, errmsg ):
         msg = "Failed to bind to server socket %s[%d]: %s"
         print >> sys.stderr, msg % ( candidate, errNo, errmsg )
         if errNo != errno.EADDRINUSE:
            raise
   return arrowName 
