# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

Logging.logD(
   id="ETH_ARP_CACHE_CLEAR",
   severity=Logging.logNotice,
   format="ARP cache of VRF %s cleared by %s on %s (%s)",
   explanation="ARP cache cleared by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

Logging.logD(
   id="ETH_ARP_CACHE_INTERFACE_CLEAR",
   severity=Logging.logNotice,
   format="ARP cache of VRF %s for interface %s cleared by %s on %s (%s)",
   explanation="ARP cache on interface cleared by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

Logging.logD(
   id="ETH_ARP_CACHE_IP_CLEAR",
   severity=Logging.logNotice,
   format="IP (%s) cleared form ARP cache of VRF %s by %s on %s (%s)",
   explanation="IP cleared from ARP cache by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

Logging.logD(
   id="ETH_IPV6_NEIGHBOR_CLEAR",
   severity=Logging.logNotice,
   format="IPv6 neighbors of VRF %s cleared by %s on %s (%s)",
   explanation="IPv6 neighbors cleared by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

Logging.logD(
   id="ETH_IPV6_NEIGHBOR_INTERFACE_CLEAR",
   severity=Logging.logNotice,
   format="IPv6 neighbors of VRF %s for interface %s cleared by %s on %s (%s)",
   explanation="IPv6 neighbors for interface cleared by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

Logging.logD(
   id="ETH_IPV6_NEIGHBOR_INTERFACE_IP_CLEAR",
   severity=Logging.logNotice,
   format="IP (%s) cleared from IPv6 neighbors of "
   "VRF %s for interface %s by %s on %s (%s)",
   explanation="IP cleared from IPV6 interface by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

