#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

# Some of the helper methods here were earlier defined in IraTestLib
# and we were were importing IraTestLib from IraTypesMixin.
# IraTypesMixin however is used by several other packages as part
# of their breadth test infrastructure and this was slowing all those
# tests. The helper methods have been moved to this file to make
# importing IraTypesMixin faster

class ArnetTypesMixin:
   '''Helper methods that will instantiate Arnet types. The intended users of
   this are dependent packages breadth tests, which use this as mixin'''
   def __init__( self ):
      pass

   @staticmethod
   def tacDefaultVrfName():
      return Tac.Type( 'L3::VrfName' ).defaultVrf

   @staticmethod
   def tacVrfName( vrfName ):
      return Tac.Value( 'L3::VrfName', vrfName )
