#!/usr/bin/env python
# Copyright (c) 2007, 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Arnet, Arnet.Device, Tracing

PamType = Tac.Type( "Arnet::Pam" )

t0 = Tracing.trace0
t1 = Tracing.trace1

class TapPamForwarder( Tac.Notifiee ):
   ''' Connects one in device to a list of out devices.
       In and out devices could be either PAM or TAP'''
   notifierTypeName = 'Tac::FileDescriptor'

   def __init__( self, tapPamDevIn, tapPamDevOutList ):
      self.tapPamDevIn_ = tapPamDevIn
      self.tapPamDevOut_ = list( tapPamDevOutList )
      assert type( tapPamDevIn ) is Arnet.Device.Tap or \
             issubclass( type( tapPamDevIn ),  PamType )
      for tapPamDevOut in self.tapPamDevOut_:
         assert type( tapPamDevOut ) is Arnet.Device.Tap or \
                issubclass( type( tapPamDevOut ),  PamType )
      self.typeDevInIsTap = type( tapPamDevIn ) is Arnet.Device.Tap

      t1( "TapIn: %s, TapOut set: %s" % ( tapPamDevIn, self.tapPamDevOut_ ) )

      if self.typeDevInIsTap:
         fileDesc_ = Tac.newInstance( 'Tac::FileDescriptor', '' )
         fileDesc_.descriptor = tapPamDevIn.fileno()
         fileDesc_.nonBlocking = True
      else:
         fileDesc_ = tapPamDevIn.fileDesc
      Tac.Notifiee.__init__( self, fileDesc_ )

   @Tac.handler( 'readableCount' )
   def handleReadableCount( self ):
      if self.typeDevInIsTap:
         pktString = self.tapPamDevIn_.recv( mtu=10000 )
         pkt = Tac.newInstance( 'Arnet::Pkt' )
         pkt.stringValue = pktString
      else:
         pkt = self.tapPamDevIn_.rxPkt()

      if pkt is None:
         return
         # transmit the pkt received onto every other interface
      for tapPamDevOut in self.tapPamDevOut_:
         if type( tapPamDevOut ) is Arnet.Device.Tap:
            tapPamDevOut.send( pkt.stringValueMaybeWithVlan )
         else:
            tapPamDevOut.txPkt = pkt

class TapConnector( object ):

   def __init__( self, *args ):
      self.tapDev_ = []
      self.tapFwd_ = []
      for ifName in args:
         self.tapDev_.append( Arnet.Device.Tap( ifname=ifName, hw=None, ip=None,
                                               netmask=None, ifprefix="tap" ) )

      for tapDev in self.tapDev_:
         t0( "creating tapforwarder with tapIn: ", tapDev )
         outList = list( self.tapDev_ )
         outList.remove( tapDev )
         self.tapFwd_.append( TapPamForwarder( tapDev, outList ) )

   def addIntftoTapConn( self, ifName ):
      tapDev = Arnet.Device.Tap( ifname=ifName, hw=None, ip=None, netmask=None, 
                                ifprefix="tap" )

      tapFwdNew = TapPamForwarder( tapDev, self.tapDev_ ) 
      self.tapDev_.append( tapDev )
      
      # Add this is new device to all other tapDev as tapDevOut
      for tapFwd in self.tapFwd_:
         tapFwd.addTapDevOut( tapDev )

      # update the tapFwd list
      self.tapFwd_.append( tapFwdNew )

   def deviceNameByIndex( self, index ):
      return self.tapDev_[ index - 1 ].name

   def deviceByIndex( self, index ):
      return self.tapDev_[ index - 1 ]
