# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Arnet.IpTestLib import IPV4
from IpTestLib import newIpPkt, IpHdrSize, Ip6HdrSize, ipVersionOf

allSPFRoutersMacAddr = "01:00:5e:00:00:05"
allSPFRoutersIpAddr = "224.0.0.5"

allDRoutersMacAddr = "01:00:5e:00:00:06"
allDRoutersIpAddr = "224.0.0.6"

IpProtoOspf = 89

# construct an ospf frame
def newOspfPkt( vlanId, dstMacAddr, dstIpAddr,
                srcMacAddr="00:1c:74:00:00:00", srcIpAddr="1.2.1.2",
                tos=0, flowLabel=0,
                data=None, version=None ):

   version = ipVersionOf( version, srcIpAddr, dstIpAddr )
   packets = []
   for vid in [ None, vlanId ]:
      # call with extraSize because the packet needs to be at least 60 bytes
      extraSize = 26 if not data else max( 26, len( data ))
      hdrSize = IpHdrSize if version == IPV4 else Ip6HdrSize
      pktData = newIpPkt( srcMacAddr=srcMacAddr,
                          dstMacAddr=dstMacAddr,
                          srcIpAddr=srcIpAddr,
                          dstIpAddr=dstIpAddr,
                          tos=tos,
                          flowLabel=flowLabel,
                          vlanId=vid,
                          protocol=IpProtoOspf,
                          ttl=1,
                          totalLen=hdrSize+extraSize,
                          extraSize=extraSize,
                          version=version )
      packet, _, _, _, _, currentOffset = pktData
      # have the same extra data so untagged and tagged packets will look the same
      # when the tagged frame is stripped of its tag. the tagged frame will be 4
      # bytes larger until it is stripped of the tag.
      for num in range( 0, extraSize ):
         packet.rawByte[ currentOffset + num ] = 0 if not data else data[num]
      
      packets.append( packet )

   untaggedFrame = packets[ 0 ].stringValue
   taggedFrame = packets[ 1 ].stringValue

   return taggedFrame, untaggedFrame
