#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

class EnabledStatusState( object ):
   '''
   vlanToVniMap : { vlanId : vni }
   vrfToSbdVlan : { vrfName : sbdVlanId }
   sbdVlanToVrf : { sbdVlanId : vrfName }
   mcastRouting : bool
   '''

   def __init__( self, name=None, vlanToVniMap=None, vrfToSbdVlan=None,
                 sbdVlanToVrf=None, multicastRouting=True ):
      self.name = name
      self.vlanToVniMap = vlanToVniMap if vlanToVniMap else {}
      self.vrfToSbdVlan = vrfToSbdVlan if vrfToSbdVlan else {}
      self.sbdVlanToVrf = sbdVlanToVrf if sbdVlanToVrf else {}
      self.mcastRouting = multicastRouting

   def toTacc( self, tacStatus ):
      tacStatus.mcastRouting = self.mcastRouting

      for vlanId in tacStatus.vlanToVniMap.iterkeys():
         if vlanId not in self.vlanToVniMap:
            del tacStatus.vlanToVniMap[ vlanId ]

      for vrfName in tacStatus.vrfToSBDVlan.iterkeys():
         if vrfName not in self.vrfToSbdVlan:
            del tacStatus.vrfToSBDVlan[ vrfName ]

      for sbdVlanId in tacStatus.sbdVlanToVrf.iterkeys():
         if sbdVlanId not in self.sbdVlanToVrf:
            del tacStatus.sbdVlanToVrf[ sbdVlanId ]

      for vlanId, vni in self.vlanToVniMap.iteritems():
         tacStatus.vlanToVniMap[ vlanId ] = vni

      for vrfName, sbdVlanId in self.vrfToSbdVlan.iteritems():
         tacStatus.vrfToSBDVlan[ vrfName ] = sbdVlanId

      for sbdVlanId, vrfName in self.sbdVlanToVrf.iteritems():
         tacStatus.sbdVlanToVrf[ sbdVlanId ] = vrfName

   def __repr__( self ):
      return str( self.__dict__ )
