# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import six

from TacUtils import Timeout

def waitForTaskRun( task, func, args=None, kwargs=None,
                    description=None, limit=200 ):
   """
   Runs the task @limit times until @func returns true
   @args is a list that will be passed as arguments to @func
   @kwargs is a dictionary that will be passed as keyword arguments to @func
   """
   if not isinstance( args, list ):
      if args is None:
         args = []
      else:
         args = [ args ]
   if kwargs is None:
      kwargs = {}
   if description is None:
      description = "task to run."

   oldForceYieldInTest = task.taskForceYieldInTest
   task.taskForceYieldInTest = True
   for _ in six.moves.xrange( limit ):
      task.taskRunFromTest()
      if func( *args, **kwargs ):
         break
   task.taskForceYieldInTest = oldForceYieldInTest

   if not func( *args, **kwargs ):
      raise Timeout( "Timed out waiting for %s" % description )
