# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

def projectName():
   """Get the name of the project for the current workspace using /p4conf.
   If we fail to read this information from /p4conf, return None."""
   try:
      with open( '/p4conf', 'r' ) as p4Conf:
         for line in p4Conf:
            if line.startswith( 'A4PROJECT=' ):
               _, name = line.split( '=', 1 )
               return name.strip()
   except IOError:
      pass
   return None
