# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import socket

def unusedPortSocket( laddr, stype, port=0 ):
   """Create a TCP (stype == "tcp") or UDP (stype == "udp") socket and
   bind it to local address laddr, allowing the kernel to select an
   unused port.  The SO_REUSEADDR socket option is set so that a child
   process can bind to the same port."""
   s = socket.socket( (laddr.find(":") == -1) and socket.AF_INET or socket.AF_INET6,
                      (stype == "udp") and socket.SOCK_DGRAM or socket.SOCK_STREAM )
   s.setsockopt( socket.SOL_SOCKET, socket.SO_REUSEADDR, 1 )
   s.bind( (laddr, port) )
   return (s.getsockname())[0:2]
