# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""Tools that make it easy to write a single command that has single
sub-commands, sub-sub-commands, etc. Eg. you'd write a utility called a4 with
commands like 'a4 edit' and 'a4 project sync'."""

from __future__ import absolute_import, division, print_function
import textwrap
import ArPyUtils.Cli

class Command( object ):
   def __init__( self, function, helpText=None ):
      self.function_ = function
      self.helpText_ = helpText

def printTreeHelp( tree, prefix='' ):
   maxLength = max( len( k ) for k in tree.iterkeys() )
   for name, subTree in sorted( tree.iteritems() ):
      if type( subTree ) == dict:
         printTreeHelp( subTree, prefix + name + ' ' )
      else:
         helpText = subTree.helpText_
         if helpText:
            initialIndent = prefix + ( ( "%%-%ds" % maxLength ) % name ) + '  '
            print( "\n".join( textwrap.wrap( helpText, width=80,
               initial_indent=initialIndent,
               subsequent_indent=( ' ' * len( initialIndent ) ) ) ) )

def main( tree, arguments ):
   """tree is a dictionary of { name: tree | Command }."""
   helpNames = [ 'help', '-h', '--help' ]

   while type( tree ) == dict:
      if not arguments:
         print( "Insufficient arguments. Expecting one of:" )
         printTreeHelp( tree, '  ' )
         return 1

      given = arguments.pop( 0 )
      options = list( tree.keys() ) + helpNames
      choice = ArPyUtils.Cli.chooseCommand( given, options )
      if choice in helpNames:
         printTreeHelp( tree, '  ' )
         return 0

      if not choice:
         print( "Unexpected argument %r. Expected one of:" % given )
         printTreeHelp( tree, '  ' )
         return 1

      tree = tree[ choice ]

   command = tree
   command.function_( arguments )
