#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import optparse, os
import EntityManager
import SharedMem
import Smash
import Tac, Plugins
import Tracing

traceHandle = Tracing.defaultTraceHandle()
t0 = traceHandle.trace0

class CliDiffPluginContext:
   def __init__( self, em, smashRoutes, hwRoutes, smash6Routes,
                 hw6Routes, routeStatus, vrfMap,
                 routeHwStatus, arpSmash, routing6HwRouteStatus, arpVrfMap ):
      self.em = em
      self.smashRoutes = smashRoutes
      self.hwRoutes = hwRoutes
      self.smash6Routes = smash6Routes
      self.hw6Routes = hw6Routes
      self.routeHwStatus = routeHwStatus
      self.arpSmash = arpSmash
      self.routing6HwRouteStatus = routing6HwRouteStatus
      self.routeStatus = routeStatus
      self.vrfMap = vrfMap
      self.arpVrfMap = arpVrfMap
      self.platformCliHelpers = []
      self.platformNames = []
   
def mountEntities( em ):
   mg = em.mountGroup()
   sm = SharedMem.entityManager( sysdbEm=em )

   routeHwStatus = mg.mount( 'routing/hardware/route/status',
                             'Routing::Hardware::RouteStatus',
                             'r' )
   routing6HwRouteStatus = mg.mount( 'routing6/hardware/route/status',
                                     'Routing6::Hardware::RouteStatus',
                                     'r' )

   mg.mount( 'routing/vrf/routingInfo/status', 'Tac::Dir', 'ri' )
   mg.mount( 'routing6/vrf/routingInfo/status', 'Tac::Dir', 'ri' )

   mg.close( blocking=True )

   vrfStatus = routeHwStatus.vrfStatus
   vrfMap = Tac.newInstance( "Ale::VrfMap" )
   # create a collection that maps vrfName to vrfId
   for vrfName in vrfStatus.keys():
      vrfMap.vrfName[ vrfStatus[ vrfName ].vrfId ] = vrfName


   vrfDir = em.root().entity[ 'routing/vrf/routingInfo/status' ]
   vrf6Dir = em.root().entity[ 'routing6/vrf/routingInfo/status' ]
   smi = Smash.mountInfo( 'reader' )

   # create a collection that maps vrfName to vrfId used by Arp Smash
   arpVrfIdMap = sm.doMount( 'vrf/vrfIdMapStatus', 'Vrf::VrfIdMap::Status', smi )
   arpVrfIdToNameMap = arpVrfIdMap.vrfIdToName
   arpVrfMap = Tac.newInstance( "Ale::VrfMap" )
   for vrfId in arpVrfIdToNameMap:
      arpVrfMap.vrfName[ vrfId ] = arpVrfIdToNameMap[ vrfId ].vrfName

   routeStatus = Tac.newInstance( "Ale::RouteStatusColl" )
   for vrfName in vrfDir.entryState.keys():
      # routeStatusColl mounts all the /routing/vrf/status/<vrfName>
      # It also mounts the default vrf
      routeStatus.routeStatusColl[ vrfName ] = \
          sm.doMount( 'routing/vrf/status/' + vrfName,
                      'Smash::Fib::RouteStatus',
                      smi )
      routeStatus.route6StatusColl[ vrfName ] = \
          sm.doMount( 'routing6/vrf/status/' + vrfName,
                      'Smash::Fib6::RouteStatus',
                      smi )

      # also mounts to routingInfo for default + per vrf info
      routeStatus.routingInfoColl[ vrfName ] = vrfDir[ vrfName ]
      routeStatus.routing6InfoColl[ vrfName ] = vrf6Dir[ vrfName ]
          
   routeStatus.routeStatusColl[ 'default' ] = \
       sm.doMount( 'routing/status', 'Smash::Fib::RouteStatus', smi )
   routeStatus.route6StatusColl[ 'default' ] = \
       sm.doMount( 'routing6/status', 'Smash::Fib6::RouteStatus', smi )
   arpSmash = sm.doMount( 'arp/status', 'Arp::Table::Status', smi )
          
   return ( routeStatus, vrfMap, routeHwStatus, arpSmash,
            routing6HwRouteStatus, arpVrfMap )

def runCmd( em, routeStatus, vrfMap, routeHwStatus, arpSmash,
            routing6HwRouteStatus, arpVrfMap ):
   smashRoutes = Tac.newInstance( "Ale::CliIpRouteTable" )
   hwRoutes = Tac.newInstance( "Ale::CliIpRouteTable" )
   smash6Routes = Tac.newInstance( "Ale::CliIp6RouteTable" )
   hw6Routes = Tac.newInstance( "Ale::CliIp6RouteTable" )

   cliDiffArgs = CliDiffPluginContext( em, smashRoutes, hwRoutes,
                                       smash6Routes, hw6Routes,
                                       routeStatus, vrfMap,
                                       routeHwStatus, arpSmash, 
                                       routing6HwRouteStatus, arpVrfMap )

   Plugins.loadPlugins( 'CliDiffPlugin', cliDiffArgs )

   for platformCliHelper, platformName in \
          zip( cliDiffArgs.platformCliHelpers, cliDiffArgs.platformNames ):
      if not platformCliHelper.routingEnabledInAnyVrf():
         print "IPv4 routing disabled in all VRFs\n"
         break
      platformCliHelper.loadIpEntriesFromHw()
      platformCliHelper.diffIpRouteTables()
      strVal = platformCliHelper.diffIpTableStringValue( platformName )
      print strVal

   for platformCliHelper, platformName in \
          zip( cliDiffArgs.platformCliHelpers, cliDiffArgs.platformNames ):
      if not platformCliHelper.routing6EnabledInAnyVrf():
         print "IPv6 routing disabled in all VRFs\n"
         break
      platformCliHelper.loadIp6EntriesFromHw()
      platformCliHelper.diffIp6RouteTables()
      strVal = platformCliHelper.diffIp6TableStringValue( platformName )
      print strVal



