# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AgentDirectory import agent
import Tac

snapshotCoreCallBack = {}
def snapshotCore( mode, sysname, agentList, ns=None ):
   for agentName in sorted( agentList ):
      agentInfo = agent( sysname, agentName )
      if agentInfo == None:
         print "%s is not running" % agentName
      else:
         # Separate agent name from VRF name if necessary
         dashLoc = agentName.find( '-' )
         if dashLoc > 0:
            agentBase = agentName[ : dashLoc ]
         else:
            agentBase = agentName

         callback = snapshotCoreCallBack.get( agentBase )
         if not callback:
            print "snapshot core not supported by %s agent" % agentName
            return

         try:
            callback( mode, ns )
            print " being generated for agent %s" % agentName
         except Tac.SystemCommandError as e:
            if e.error in ( 1, 2 ):
               print "Failed to connect to %s agent to generate core" % \
                  agentName
            elif e.error == 3:
               print "Timeout encountered while generating core for %s agent" \
                     % agentName
            else:
               print "Core file generation for %s agent failed" % agentName
