# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
Some common definitions shared by Sysdb plugins and other components.

Please do not put code here.
"""

import Tac
from enum import Enum

roleNameRe = '[A-Za-z0-9_-]+' 
roleRegexRe = '.+'

acctLogFileName = '/var/log/account.log'

MAX_ROLES = 64  # Max number of roles allowed
MAX_SEQ = 256   # Max number of rules allowed for each role
SEQ_INC = 10    # Default increment of rule sequence number

class AAA_PWENT_RESULT( Enum ):
   UNKNOWN = 1
   INVALID = 2

authzRuleType = Tac.Type( 'LocalUser::Action' )
authzBuiltinRoles = {
      'network-admin' : [
         # seq, action, regex, modeKey
         ( 10, authzRuleType.permit, '.*', '' ) ],
      'network-operator' : [
         # deny bash, python-shell and piped commands
         ( 10, authzRuleType.deny, 'configure|bash|python-shell|\|', 'exec' ),
         ( 20, authzRuleType.permit, '.*', 'exec' ) ]
}

