# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from SfFruHelper import SfFruHelper
import Tac
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.SfFruHelper" )
t0 = Tracing.trace0

class AWSFruHelper( SfFruHelper ):
   def __init__( self, driver ):
      SfFruHelper.__init__( self, driver )

   def hasManagementIntf( self ):
      return False

   def doGetPci( self, devName ):
      # AWS t2 instances don't have PCI device
      if self.getDriver( devName ) == "vif":
         return ""
      else:
         return super( AWSFruHelper, self ).doGetPci( devName )

   def getEthernetDriver( self ):
      lspciOp = Tac.run( [ "/sbin/lspci" ], stdout=Tac.CAPTURE )
      lspciOp = [ x for x in lspciOp.splitlines() if 'Ethernet' in x ]

      if any( [ x for x in lspciOp if 'Virtio' in x ] ):
         driver = "virtio"
      elif any( [ x for x in lspciOp if 'Intel' in x ] ):
         driver = "ixgbevf"
      else:
         # AWS uses "ixgbevf" driver for intel based nics for C4 instances and "ena"
         # driver for c5 types.
         driver = "ena"
      return driver
