#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import re
import subprocess as sp
import sys
from Tac import Timeout
import time
from Fru.FruBaseVeosDriver import parseVeosConfig

# Tac.waitFor prints to stdout, which appears in console log, so wrote my own
def waitFor( func, timeout=60, warnAfter=30, noTimeout=False,
             description='unknown' ):
   timer = 0
   while not func() and ( True if noTimeout else timer < timeout ):
      if timer == warnAfter:
         sys.stderr.write( "Warning: taking a while for %s" % description )
      time.sleep( 1 )
      timer += 1
   if not func():
      raise Timeout( 'Timed out waiting for %s' % description )

def waagentCheckStart( ifname='et1' ):
   def ipFound():
      try:
         output = sp.check_output( [ '/usr/sbin/ip', 'addr', 'show', 'dev',
                                     ifname ],
                                   stderr=open( os.devnull, 'w' ) )
         return bool( re.search( 'inet [0-9]+.[0-9]+.[0-9]+.[0-9]+', output ) )
      except sp.CalledProcessError:
         return False
   def routeFound():
      with open( '/proc/net/route', 'r' ) as routeFile:
         routes = routeFile.readlines()
      for route in routes:
         cols = route.split( '\t' )
         if len( cols ) >= 4:
            FLAG_GATEWAY = 0x02
            if cols[ 0 ] == ifname and cols[ 1 ] == '00000000' and \
               int( cols[ 3 ] ) & FLAG_GATEWAY != 0:
               return True
      return False
   waitFor( lambda: ipFound() and routeFound(), warnAfter=300, noTimeout=True,
            description=(
               'ip address and route to be added to %s before starting Waagent'
               % ifname ) )
   sp.check_call( [ 'service', 'waagent', 'start' ] )

if __name__ == '__main__':
   sysClassDmi = '/sys/class/dmi/id/'
   sysVendor = ''
   if os.path.exists( os.path.join( sysClassDmi, "sys_vendor" ) ):
      sysVendor = str(
         file( os.path.join( sysClassDmi, "sys_vendor" ) ).read() ).rstrip()
   if 'Microsoft Corporation' == sysVendor:
      veosConfig = parseVeosConfig()
      ifname = 'ma1' if veosConfig[ 'PRIMARYPORT' ] == "management" else "et1"
      waagentCheckStart( ifname )
