#!/bin/bash

# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# ssdinit.sh : script run once at boot time as part of systemd startup to mount
#              and initialize the SSD device for use by Arista.
#
# Formerly included in /etc/rc.sysinit now invoked by systemd

FLASH_DRIVE=/mnt/flash
SSD_NO_USE_OVERRIDE=${FLASH_DRIVE}/no_ssd_var
SSD_DRIVE=/mnt/drive
SSD_DRIVE_LO_DEV=${SSD_DRIVE}/.arista_varlo
CRASH_KERNEL_ONLY_DIR=/proc/vmcore

ssd_varlo_dev_exists() {
    if [ -e ${SSD_DRIVE_LO_DEV} ]; then
        return 0
    fi
    return 1
}

vfatcleanup() {
    # Clean up any no longer needed Arista vfat space allocation
    if ssd_varlo_dev_exists; then
        rm -rf ${SSD_DRIVE_LO_DEV} 2> /dev/null
    fi
}

no_use_override_file_exists() {
    if [ -e ${SSD_NO_USE_OVERRIDE} ]; then
        return 0
    fi
    return 1
}

crash_kernel_only_dir() {
    if [ -d ${CRASH_KERNEL_ONLY_DIR} ]; then
        return 0
    fi
    return 1
}

ssd_dir_exists() {
    if [ -d ${SSD_DRIVE} ]; then
        return 0
    fi
    return 1
}

mount_all_block_dev() {
   local dev="$(find -L /sys/block -maxdepth 3 -xdev -name dev ! -wholename /sys/block/loop\* ! -wholename /sys/block/mmcblk\?boot\* 2>/dev/null | sed 's;.*/\([^/]*\)/dev$;\1;')"

   for d in $dev; do /sbin/initblockdev "${d##*/}" add --mountssd; done
}

# fsck and mount the ssd
mount_all_block_dev

# We need to invoke archivetree.py to copy /proc/modules
/usr/bin/archivetree.py -r -s /proc/modules -a /mnt/flash/debug/ &> /dev/null

if ! no_use_override_file_exists; then
    if ! crash_kernel_only_dir && ssd_dir_exists; then
        if mountpoint -q ${SSD_DRIVE}; then
            # Cleanup any old vfat archive space, we don't support that any more
            vfatcleanup
            echo "Arista ssdinit: initialization complete"
        else
            echo "Arista ssdinit: An SSD device is not mounted"
        fi
    fi
else
    echo "Arista ssdinit: ssd use disabled by /mnt/flash/no_ssd_var"
fi
