#! /bin/sh

# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Write configuration of block and net devices provided by firmware. Record
# down whitebox platform id string.

process_cmdline() {
   while IFS='=' read -r n v; do
      case $n in
         block_*) echo "$v ${n#block_}" >>/etc/blockdev ;;
         net_*)   echo "$v ${n#net_}" | sed "s/mgmt/ma/" >>/etc/netdev ;;
         nethw)   echo "$v" >/etc/nethw ;;
         onie_platform) echo "$v" >/etc/onie_platform ;;
      esac
   done
}

cat /proc/cmdline | tr " " "\n" | process_cmdline
