#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import Tac
from eunuchs.if_arp_h import ARPHRD_ETHER
import re
from subprocess import call

# turn off tx checksuming for vnics so OS does it
# this is to take care of patchpanel/vMPC setup and is not required in
# real world as the physical nic will do the tx checksumming
# This script can be run by invoking from rc.eos

# Get all ethernet interface device names
sysClassNet = "/sys/class/net"
devNames = []
for devName in os.listdir( sysClassNet ):
   if not os.path.isdir( os.path.join( sysClassNet, devName ) ):
      continue
   devType = int(file( os.path.join( sysClassNet, devName, "type" )).read())
   pat = re.compile( '^(vmnic)*et[0-9]+' )
   if ( devType == ARPHRD_ETHER ) and pat.match( devName ):
      call( ['ethtool', '-K', devName, 'tx', 'off'] )
