#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ctypes import CDLL
import os
import imp

def main():
   # libAgentLogrotateLib will handle signal from logrotatee
   CDLL( "libAgentLogrotateLib.so.0.0.0" )
   sandScriptPath = '/usr/bin/SandDropCounterMonitor.py'
   strataScriptPath = '/usr/bin/StrataDropCounterMonitor.py'
   if os.path.isfile( sandScriptPath ):
      assert not os.path.isfile( strataScriptPath )
      # BUG483788 Use importlib.util.spec_from_file_location for Python 3.5+
      dropCounterMonitor = imp.load_source( 'SandDropCounterMonitor',
                                            sandScriptPath )
   elif os.path.isfile( strataScriptPath ):
      assert not os.path.isfile( sandScriptPath )
      # BUG483788 Use importlib.util.spec_from_file_location for Python 3.5+
      dropCounterMonitor = imp.load_source( 'StrataDropCounterMonitor',
                                            strataScriptPath )
   else:
      print "0"
   dropCounterMonitor.main()

if __name__ == "__main__":
   main()
