#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# APP DMA application simulator

import Tac
import sys, getopt

def usage():
   print "%s -a <appln> -m <maxPkts> -f <freqeuncy> -r <runTime>" % sys.argv[0]

def createSm( appln, maxPkts, freq ):
   config = Tac.newInstance( "AppDma::Config", "config" )
   config.interval = freq
   config.maxPkts = maxPkts
   status = Tac.newInstance( "AppDma::Status", "status" )
   appRxDmaSm = Tac.newInstance( "AppDma::AppRxDmaControlSm",
                                 appln, config, status, Tac.activityManager.clock )
   return appRxDmaSm

if __name__ == "__main__":
   if len( sys.argv ) != 9:
      usage()
      sys.exit()
   try:
      opts, args = getopt.getopt( sys.argv[1:], "a:n:f:r:" )
   except getopt.GetoptError:
      usage()
      sys.exit()

   argAppln = 0
   argNumPkts = 0
   argFrequency = 0.1
   argRunTime = 0
      
   for opt, arg in opts:
      if opt == '-a':
         argAppln = int( arg )
      elif opt == '-n':
         argNumPkts = int( arg )
      elif opt == '-f':
         argFrequency = float( arg )
      elif opt == '-r':
         argRunTime = int( arg )
      else:
         usage()
         sys.exit()

   print "Args: appln:%d maxPkts:%d frequency:%f runTime:%d" % \
            ( argAppln, argNumPkts, argFrequency, argRunTime )

   dmaSm = createSm( argAppln, argNumPkts, argFrequency )

   Tac.runActivities( argRunTime )
