# Override the default help command with something more beginner-friendly
help ()
{
    if [ $EOSCLIRUNNING ]; then
        exitcmd="exit"
    else
        exitcmd="Cli"
    fi
    cat <<EOF

Arista Networks EOS shell

The shell is intended for advanced administrative tasks only.  To return
to the Arista Networks EOS command-line interface, type

  $exitcmd

EOF
}
# Exporting functions isn't a standard operation, thus shells other than bash may
# fail to do so. Discarding outputs to avoid error messages.
declare -fx help >/dev/null 2>&1

# Add sbin dirs to path for users in group eosadmin.
if id -nG | grep -wq eosadmin ; then
   # pathmunge function comes from /etc/profile which sources this file.
   pathmunge /sbin
   pathmunge /usr/sbin
   pathmunge /usr/local/sbin
fi

# Print a banner if this is an interactive shell
if [ "$PS1" ]; then
    echo -e "\nArista Networks EOS shell\n"
fi

set_clocal()
{
    console=$( grep -E "console=ttyS[0-9]+" /proc/cmdline -o | cut -d"=" -f2 | \
               tail -n 1 )
    if [ -z "$console" ]; then
        console="/dev/ttyS0"
    else
        console="/dev/$console"
    fi
    if [ "`/usr/bin/tty`" = ${console} ]; then
       /usr/bin/stty -F ${console} clocal
    fi
}

# besides clearing the terminal and other settings, 'reset' command enables 
# modem control signals of tty. If a user exits out of login session after
# 'reset', systemd is stuck during open of /dev/ttyS0 waiting for modem to be 
# ready. Since we do not have modem features on some of our UARTs, we disable 
# modem control signals while exiting bash shell on console
trap set_clocal EXIT
